<?php
    // Load page from template
    require_once "dashboard.php";
?>

<!-- Start the custom CSS for this page -->
<?= startSection('css') ?> 
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="<?=$baseURL?>/assets/css/dataTables.bootstrap4.css">

<?= endSection() ?> 

<!-- Start the content for this page -->
<?= startSection('content') ?> 
    <div class="container-fluid">

        <?= yieldSection('dashboard') ?> 

        <div class="row justify-content-center mb-4">
            <div class="col-11">
                <div class="row">
                    <div class="col-12 col-lg-12 col-xl-12">
                        <div class="card shadow mb-4 mt-4">
                            <div class="card-body mx-4 my-4">
                                <div class="row toolbar">
                                    <div class="col-md-6">
                                        <h2 class="h3 page-title">List of requesting for donation</h2>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-row float-right"> 
                                            <a href="<?=$basePath?>/create-request" class="btn btn-primary btn-lg" type="button">Create New</a>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="row toolbar">
                                    <div class="col-12 mt-3">
                                        <div class="form-row float-right "> 
                                            <div class="form-group mr-3">
                                                <select id="status" class="form-control" required>
                                                    <option value="" selected>Select All Status</option>
                                                    <option value="Pending">Pending</option>
                                                    <option value="Verified">Verified</option>
                                                    <option value="Approved">Approved</option>
                                                    <option value="Denied">Denied</option>
                                                    <option value="Claimed">Claimed</option>
                                                </select>
                                            </div>
                                            <div class="form-group mr-3">
                                                <select id="donation_type" class="form-control" required>
                                                    <option value="" selected>Select All Donation</option>
                                                    <option value="Monetary">Monetary</option>
                                                    <option value="Material">Material</option>
                                                </select>
                                            </div>
                                            <div class="form-group mr-3">
                                                <select id="location" class="form-control" required>
                                                    <!-- Options will be populated here -->
                                                </select>
                                            </div> 
                                            <div class="form-group">
                                                <button class="btn btn-primary fe fe-search fe-16" id="filterData"> Filter</button>
                                            </div> 
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <table class="table datatables table-hover" id="tblData">
                                    <thead class="bg-light font-weight-bold">
                                        <tr>
                                            <th><strong>No.</strong></th>
                                            <th><strong>Member</strong></th>
                                            <th><strong>Donation</strong></th>
                                            <th><strong>Location</strong></th>
                                            <th><strong>Purpose</strong></th>
                                            <th><strong>Status</strong></th>
                                        </tr>
                                    </thead>
                                    <tbody id="donation-request-body">
                                        <!-- Data rows will be populated here dynamically -->
                                    </tbody>
                                </table>
                            </div> 
                        </div> 
                    </div>
                </div>

            </div>
        </div>
    </div>
<?= endSection() ?> 

<!-- Start the java scripts for this page -->
<?= startSection('scripts') ?> 
<script src='<?=$baseURL?>/assets/js/jquery.dataTables.min.js'></script>
<script src='<?=$baseURL?>/assets/js/dataTables.bootstrap4.min.js'></script>
<script >
    $(document).ready(function(){   
       
        var tblData = $('#tblData').DataTable();

        getLocationList();
        getDonationRequest();

        $("#filterData").on('click', function(e){ 
            getDonationRequest();
        });

        function getDonationRequest(){
            showLoader();
            var status   	        = $("#status").val();
            var donation_type   	= $("#donation_type").val();
            var location   	        = $("#location").val();
            tblData.clear().draw();
            $.ajax({
				url: '<?=$baseURL?>/controller/ctrl-request.php',
                type: "POST",
                contentType: "application/json",
                data: JSON.stringify({ 
                    trans               : "getDonationRequest",
                    page                : "request",
                    status              : status,
                    donation_type       : donation_type,
                    location            : location
                }), 
                success: function(response) {
                    closeLoader();
                    if (response.response_code === "0") {
                        response.results.forEach(function(item, index) {
                            var htmlData;
                            switch (item.donation_type) {
                            case "Material":
                                htmlData = `<div>
                                                <span><strong>${item.donation_type}</strong></span><br>
                                                <span><strong>Item: </strong>${item.item_id}</span><br>
                                                <span><strong>Quantity: </strong>${item.item_quantity}</span>
                                            </div>`; 
                                break;
                            case "Monetary":
                                htmlData = `<div>
                                                <span><strong>${item.donation_type}</strong></span><br>
                                                <span><strong>Amount: </strong>${item.amount}</span><br>
                                            </div>`; 
                                break;
                            }

                            tblData.row.add([
                                index + 1,
                                `<div>
                                    <strong>${item.member_name}</strong><br>
                                    <span><i class="fe fe-home"></i> ${item.member_address}</span><br>
                                    <span><i class="fe fe-mail"></i> ${item.member_email}</span>, 
                                    <span><i class="fe fe-phone"></i> ${item.member_phone}</span>
                                </div>`,
                                htmlData,
                                item.location,
                                item.purpose,
                                item.status,
                            ]).draw();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: response.title,
                            text: response.description,
                            confirmButtonText: 'OK',
                            didOpen: () => {
                                Swal.hideLoading();
                            },  
                        });
                    }
                },
                error: function(xhr, status, error) { 
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed',
                        text: 'An error occurred while submitting the event!',
                        confirmButtonText: 'OK',
                        didOpen: () => {
                            Swal.hideLoading();
                        },  
                    });
                }
            });
        }


        function getLocationList(){
            $.ajax({
				url: '<?=$baseURL?>/controller/ctrl-global.php',
                type: "POST",
                contentType: "application/json",
                data: JSON.stringify(
                    { 
                        trans: "getLocations" 
                    }
                ), 
                success: function(response) {
                    if (response.response_code === "0") {
                        var items = response.items;
                        var dropdown = $('#location');

                        // Clear existing options
                        dropdown.empty();     
                        dropdown.append('<option value="" selected>Select All Location</option>');

                        // Populate the dropdown with items
                        $.each(items, function(index, item) {
                            dropdown.append('<option value="' + item.location_description + '">' + item.location_description + '</option>');
                        });
                    }
                }
            });
        }
    });
</script> 
<?= endSection() ?> 