<?php
    // Start output buffering
    ob_start();

    // Load page from template
    require_once "navbar.php";
    // require_once $template; 

    $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $uri_segments = explode('/', $uri_path);
    
    $is_member = false;
	if (strpos($uri_path, 'member-request') !== false) {
        $is_member = true;
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="description" content="">
        <meta name="author" content="">
        <link rel="icon" href="<?=$baseURL?>/assets/images/pwdlogo.png">
        <title><?=$ENV['APP_NAME']?></title>
        <!-- Simple bar CSS -->
        <link rel="stylesheet" href="<?=$baseURL?>/assets/css/simplebar.css">
        <!-- Fonts CSS -->
        <link href="https://fonts.googleapis.com/css2?family=Overpass:ital,wght@0,100;0,200;0,300;0,400;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
        <!-- Icons CSS -->
        <link rel="stylesheet" href="<?=$baseURL?>/assets/css/feather.css">
        <!-- Date Range Picker CSS -->
        <link rel="stylesheet" href="<?=$baseURL?>/assets/css/daterangepicker.css">
        <!-- Swal -->
        <link rel="stylesheet" href="<?=$baseURL?>/assets/css/sweetalert2.min.css">
        <!-- App CSS -->
        <link rel="stylesheet" href="<?=$baseURL?>/assets/css/app-light.css" id="lightTheme">
        <link rel="stylesheet" href="<?=$baseURL?>/assets/css/app-dark.css" id="darkTheme" disabled>
        
        <!-- Custom styles -->
        <?php yieldSection('css') ?>

    </head>
    <body class="horizontal light">

        <div class="wrapper">

            <?= !$is_member?yieldSection('navbar'):'' ?> 

            <main role="main" class="main-content">
                <?= yieldSection('content') ?>  
            </main>
            
        </div>

        <script src="<?=$baseURL?>/assets/js/jquery.min.js"></script>
        <script src="<?=$baseURL?>/assets/js/popper.min.js"></script>
        <script src="<?=$baseURL?>/assets/js/moment.min.js"></script>
        <script src="<?=$baseURL?>/assets/js/bootstrap.min.js"></script>
        <script src="<?=$baseURL?>/assets/js/simplebar.min.js"></script>
        <script src='<?=$baseURL?>/assets/js/daterangepicker.js'></script>
        <script src='<?=$baseURL?>/assets/js/jquery.stickOnScroll.js'></script>
        <script src="<?=$baseURL?>/assets/js/tinycolor-min.js"></script>
        <script src="<?=$baseURL?>/assets/js/sweetalert2.all.min.js"></script> 
        <script src="<?=$baseURL?>/assets/js/config.js"></script>
        <script src="<?=$baseURL?>/assets/js/apps.js"></script> 
        <!-- <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script> -->
         
        <script>
            var routes = <?= json_encode($routes); ?>;
            document.title = "<?= isset($title) ? $ENV['APP_NAME'].' - '.htmlspecialchars($title) : $ENV['APP_NAME'] ?>";

            function showLoader() {
                Swal.fire({
                    title: "Processing...",
                    html: "Please wait while we are processing your request!",
                    showConfirmButton: false,
                    allowOutsideClick: false,
                    allowEscapeKey: false,  
                    didOpen: () => {
                        Swal.showLoading();
                    },  
                });
            }

            function closeLoader() {
                Swal.close();
            }
        </script>

        <!-- Update page title -->
        <?= yieldSection('scripts') ?>
        
    </body>
</html>

<?php
    // End output buffering and flush the content to the output
    ob_end_flush();
?>