<?php
    // Load page from template
    require_once "dashboard.php";
?>

<!-- Start the custom CSS for this page -->
<?= startSection('css') ?> 
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="<?=$baseURL?>/assets/css/dataTables.bootstrap4.css">

<?= endSection() ?> 

<!-- Start the content for this page -->
<?= startSection('content') ?> 
    <div class="container-fluid">

        <?= yieldSection('dashboard') ?> 

        <div class="row justify-content-center mb-4">
            <div class="col-11">
                <div class="row">
                    <div class="col-12 col-lg-12 col-xl-12">
                        <div class="card shadow mb-4 mt-4">
                            <div class="card-body mx-4 my-4">
                                <div class="row toolbar">
                                    <div class="col-md-6">
                                        <h2 class="h3 page-title">List of Material Item</h2>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-row float-right"> 
                                            <a href="<?=$basePath?>/create-items" class="btn btn-primary btn-lg" type="button">Create New</a>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <table class="table datatables table-hover" id="tblData">
                                    <thead class="bg-light font-weight-bold">
                                        <tr>
                                            <th><strong>No.</strong></th>
                                            <th><strong>Code</strong></th>
                                            <th><strong>Title</strong></th>
                                            <th><strong>Description</strong></th>
                                        </tr>
                                    </thead>
                                    <tbody id="donation-request-body">
                                        <!-- Data rows will be populated here dynamically -->
                                    </tbody>
                                </table>
                            </div> 
                        </div> 
                    </div>
                </div>

            </div>
        </div>
    </div>
<?= endSection() ?> 

<!-- Start the java scripts for this page -->
<?= startSection('scripts') ?> 
<script src='<?=$baseURL?>/assets/js/jquery.dataTables.min.js'></script>
<script src='<?=$baseURL?>/assets/js/dataTables.bootstrap4.min.js'></script>
<script >
    $(document).ready(function(){   
       
        var tblData = $('#tblData').DataTable();

        getDonationEvents();

        function getDonationEvents(){
            showLoader();
            
            tblData.clear().draw();
            $.ajax({
				url: '<?=$baseURL?>/controller/ctrl-items.php',
                type: "POST",
                contentType: "application/json",
                data: JSON.stringify({ 
                    trans : "getMaterialItems" 
                }), 
                success: function(response) {
                    closeLoader();
                    if (response.response_code === "0") {
                        response.results.forEach(function(item, index) { 
                            tblData.row.add([
                                index + 1,
                                item.code,
                                `<strong>${item.title}</strong>`,
                                item.item_description,
                                item.created_at
                            ]).draw();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: response.title,
                            text: response.description,
                            confirmButtonText: 'OK',
                            didOpen: () => {
                                Swal.hideLoading();
                            },  
                        });
                    }
                },
                error: function(xhr, status, error) { 
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed',
                        text: 'An error occurred while submitting the event!',
                        confirmButtonText: 'OK',
                        didOpen: () => {
                            Swal.hideLoading();
                        },  
                    });
                }
            });
        }

    });
</script> 
<?= endSection() ?> 