    
<!-- Start the content for this page -->
<?= startSection('content') ?> 
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-12 col-lg-10 col-xl-8">
            <h2 class="h3 mb-4 page-title">Request Donations</h2>
            <div class="my-4">
                <div class="card shadow mb-4">
                    <div class="card-body">
                        <form name="frmData" id="submitRequest" class="needs-validation" >
                            <!-- Member Fields -->
                            <h4 class="h4 mb-2 mt-3">Member Details</h4>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="title">Health Card ID</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="member_id" required>
                                        <div class="input-group-append">
                                            <button class="btn btn-primary" type="button" id="verifyCardId">Verify</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-2">
                                    <label for="member_name">Name</label>
                                    <label type="text" class="form-control bg-light" id="member_name"></label>
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label for="member_address">Address</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fe fe-home"></i></span>
                                        </div>
                                        <label type="text" class="form-control bg-light" id="member_address"></label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-2">
                                    <label for="member_email">Email</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fe fe-mail"></i></span>
                                        </div>
                                        <label type="text" class="form-control bg-light" id="member_email"></label>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label for="member_phone">Phone</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fe fe-phone"></i></span>
                                        </div>
                                        <label type="text" class="form-control bg-light" id="member_phone"></label>
                                    </div>
                                </div>
                            </div>
                            <!-- Donation Fields -->
                            <h4 class="h4 mb-2 mt-3">Donation Details</h4>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="donation_type">Type of Donation</label>
                                    <select id="donation_type" class="form-control" required>
                                        <option value="" disabled selected>Select</option>
                                        <option value="Material">Material</option>
                                        <option value="Monetary">Monetary</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="location">Location</label>
                                    <select class="form-control" id="location" required>
                                    </select>
                                </div>
                            </div>
                            <!-- Monetary Donation Fields (Hidden by default) -->
                            <div id="monetary_fields" class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="amount">Amount</label>
                                    <input type="number" class="form-control" id="amount">
                                </div>
                            </div>
                            <!-- Material Donation Fields (Hidden by default) -->
                            <div id="material_fields">
                                <div class="form-row">
                                    <div class="col-md-6 mb-3">
                                        <label for="item_id">Item</label>
                                        <select class="form-control" id="item_id">
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="item_quantity">Number of item</label>
                                        <input type="number" class="form-control" id="item_quantity">
                                    </div>
                                </div> 
                            </div> 
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="purpose">Purpose</label>
                                    <textarea class="form-control" id="purpose" rows="2" required></textarea>
                                </div>
                            </div>
                            <div class="form-row">
                                <button class="btn btn-primary btn-lg my-2" type="submit" >Submit Request</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 
<?= endSection() ?> 


<!-- Start the java scripts for this page -->
<?= startSection('scripts') ?> 
<script >
    $(document).ready(function(){    
        var isVerified = false;

        getLocations();  
        getMaterialItems();

        $("#monetary_fields").hide();
        $("#material_fields").hide(); 

        $("#donation_type").on('change', function(){    
            if($(this).val()=="Monetary") {
                $("#monetary_fields").show();
                $("#material_fields").hide();
                $('#amount').attr('required', 'required'); 
                $('#item_id').removeAttr('required'); 
                $('#item_quantity').removeAttr('required'); 
            } else if($(this).val()=="Material") {
                $("#material_fields").show();
                $("#monetary_fields").hide();
                $('#amount').removeAttr('required'); 
                $('#item_id').attr('required', 'required');
                $('#item_quantity').attr('required', 'required'); 
            }
        }).change();

        $("#verifyCardId").on('click', function(e){ 
            verifyCardId();
        });

        $('#submitRequest').on('submit', function(e) {
            e.preventDefault(); 

            if (this.checkValidity()) {
                showLoader();
                var member_id       = $("#member_id").val();
                var donation_type   = $("#donation_type").val();
                var item_id         = $("#item_id").val();
                var item_quantity   = $("#item_quantity").val();
                var amount   	    = $("#amount").val();
                var purpose   	    = $("#purpose").val();
                var location   	    = $("#location").val();
                
                if(!isVerified) {
                    Swal.fire({
                        icon: "error",
                        title: "Verification",
                        text: "Please verify your account!",
                        confirmButtonText: "OK",
                        didOpen: () => {
                            Swal.hideLoading();
                        },  
                    });
                } else { 
                    $.ajax({
						url: '<?=$baseURL?>/controller/ctrl-request.php', 
                        type: "POST",
                        contentType: "application/json",
                        data: JSON.stringify({ 
                            trans           : "addRequestDonation",
                            member_id       : member_id,
                            donation_type   : donation_type,
                            item_id         : item_id,
                            item_quantity   : item_quantity,
                            amount         	: amount,
                            purpose         : purpose,
                            location        : location
                        }), 
                        success: function(response) {
                            if (response.response_code === "0") {
                                Swal.fire({
                                    icon: 'success',
                                    title: response.title,
                                    text: response.description,
                                    confirmButtonText: 'OK'
                                }).then((result) => {
                                    window.location.href = '<?=$basePath?>/request';  
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: response.title,
                                    text: response.description,
                                    confirmButtonText: 'OK',
                                    didOpen: () => {
                                        Swal.hideLoading();
                                    },  
                                });
                            }
                        },
                        error: function(xhr, status, error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Request Failed',
                                text: 'We encountered an error while processing your request. Please try again!',
                                confirmButtonText: 'OK',
                                didOpen: () => {
                                    Swal.hideLoading();
                                },  
                            });
                        }
                    });
                }
            } else {
                this.reportValidity();  
            }
        });


        function getLocations(){
            $.ajax({
				url: '<?=$baseURL?>/controller/ctrl-global.php',
                type: "POST",
                contentType: "application/json",
                data: JSON.stringify({ trans: "getLocations" }), 
                success: function(response) {
                    if (response.response_code === "0") {
                        var items = response.items;
                        var dropdown = $('#location');

                        // Clear existing options
                        dropdown.empty();
                        dropdown.append('<option value="" disabled selected>Select location</option>');

                        // Populate the dropdown with items
                        $.each(items, function(index, item) {
                            dropdown.append('<option value="' + item.location_description + '">' + item.location_description + '</option>');
                        });
                    }
                }
            });
        }

        function getMaterialItems(){
            $.ajax({
				url: '<?=$baseURL?>/controller/ctrl-global.php',
                type: "POST",
                contentType: "application/json",
                data: JSON.stringify({ trans: "getMaterialItems" }), 
                success: function(response) {
                    if (response.response_code === "0") {
                        var items = response.items;
                        var dropdown = $('#item_id');

                        // Clear existing options
                        dropdown.empty();
                        dropdown.append('<option value="" disabled selected>Select item</option>');

                        // Populate the dropdown with items
                        $.each(items, function(index, item) {
                            dropdown.append('<option value="' + item.id + '">' + item.title + '</option>');
                        });
                    }
                }
            });
        }

        function verifyCardId(){
            showLoader();
            var member_id = $("#member_id").val();
            $.ajax({
				url: '<?=$baseURL?>/controller/ctrl-global.php', 
                type: "POST",
                contentType: "application/json",
                data: JSON.stringify({ trans: "verifyCardId", member_id: member_id }), 
                success: function(response) {
                    closeLoader();
                    if (response.response_code === "0") {
                        var data = response.results;
                        console.log(data);
                        verifyBirthDate(data);
                    }
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed',
                        text: 'An error occurred while submitting the event!',
                        confirmButtonText: 'OK'
                    });
                }
            });
        }

        function verifyBirthDate(data){
            Swal.fire({
                title: "<strong>Verify</strong>",
                icon: "info",
                html: `<div>
                            <label for="purpose">Enter your birthday for verification</label>
                            <input type="date" class="form-control bday">
                       </div>`,
                showCloseButton: true,
                showCancelButton: true,
                confirmButtonText: "Submit",
                cancelButtonText: "Cancel",
            }).then((result) => {
                if (result.isConfirmed) {
                    var bday1 = Date.parse($(".bday").val()); 
                    var bday2 = Date.parse(data.birthday)
                    if(bday1 == bday2){
                        Swal.fire("Verification successfull!", "", "success");
                        $("#member_name").text(data.fname+' '+data.lname);
                        $("#member_address").text(data.location_st+' '+data.location_brgy+', '+data.location_city+', '+data.location_prov);
                        $("#member_email").text(data.email);
                        $("#member_phone").text(data.phone);
                        isVerified = true;
                    } else {
                        Swal.fire({
                            icon: "error",
                            title: "Birtday is incorrect!",
                            text: "Please enter your birthday.",
                            confirmButtonText: "OK"
                        }).then((result) => {
                            verifyBirthDate(data);
                        });
                    }
                }
            });
        }
    });
</script> 
<?= endSection() ?> 