    
<!-- Start the content for this page -->
<?= startSection('content') ?> 
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-12 col-lg-10 col-xl-8">
            <h2 class="h3 mb-4 page-title">Material Item</h2>
            <div class="my-4">
                <div class="card shadow mb-4">
                    <div class="card-body">
                        <form name="frmData" id="submitRequest" class="needs-validation" >
                            <h4 class="h4 mb-2 mt-3">Item Details</h4> 
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="title">Title</label>
                                    <input type="text" class="form-control" id="title" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="item_description">Item Description</label>
                                    <textarea class="form-control" id="item_description" rows="2" required></textarea>
                                </div> 
                            </div> 
                            <div class="form-row">
                                <button class="btn btn-primary btn-lg my-2" type="submit" >Submit Request</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 
<?= endSection() ?> 


<!-- Start the java scripts for this page -->
<?= startSection('scripts') ?> 
<script >
    $(document).ready(function(){     

        $('#submitRequest').on('submit', function(e) {
            e.preventDefault(); 

            if (this.checkValidity()) {
                showLoader();
                var title               = $("#title").val();
                var item_description    = $("#item_description").val(); 
                 
                $.ajax({
					url: '<?=$baseURL?>/controller/ctrl-items.php', 
                    type: "POST",
                    contentType: "application/json",
                    data: JSON.stringify({ 
                        trans           : "addMaterialItems",
                        title           : title,
                        item_description: item_description
                    }), 
                    success: function(response) {
                        if (response.response_code === "0") {
                            Swal.fire({
                                icon: 'success',
                                title: response.title,
                                text: response.description,
                                confirmButtonText: 'OK'
                            }).then((result) => {
                                window.location.href = '<?=$basePath?>/items';  
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: response.title,
                                text: response.description,
                                confirmButtonText: 'OK',
                                didOpen: () => {
                                    Swal.hideLoading();
                                },  
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Request Failed',
                            text: 'We encountered an error while processing your request. Please try again!',
                            confirmButtonText: 'OK',
                            didOpen: () => {
                                Swal.hideLoading();
                            },  
                        });
                    }
                }); 
            } else {
                this.reportValidity();  
            }
        });
    });
</script> 
<?= endSection() ?> 