    
<!-- Start the content for this page -->
<?= startSection('content') ?> 
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-12 col-lg-10 col-xl-8">
            <h2 class="h3 mb-4 page-title">Create Donation Event</h2>
            <div class="my-4">
                <div class="card shadow mb-4">
                    <div class="card-body">
                        <form name="frmData" id="submitRequest" class="needs-validation" >
                            <!-- Donation Fields -->
                            <h4 class="h4 mb-2 mt-3">Donation Details</h4>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="title">Title</label>
                                    <input type="text" class="form-control" id="title" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="schedule">Schedule</label>
                                    <input type="datetime-local" class="form-control" id="schedule" required>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="donation_type">Type of Donation</label>
                                    <select id="donation_type" class="form-control" required>
                                        <option value="" disabled selected>Select</option>
                                        <option value="Material">Material</option>
                                        <option value="Monetary">Monetary</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="location">Location</label>
                                    <select class="form-control" id="location" required>
                                    </select>
                                </div>
                            </div>
                            <!-- Monetary Donation Fields (Hidden by default) -->
                            <div id="monetary_fields" class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="total_amount">Total Amount</label>
                                    <input type="number" class="form-control" id="total_amount">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="total_beneficiary">Expected number of beneficiary</label>
                                    <input type="number" class="form-control" id="total_beneficiary">
                                </div>
                            </div>
                            <!-- Material Donation Fields (Hidden by default) -->
                            <div id="material_fields">
                                <div class="form-row">
                                    <div class="col-md-6 mb-3">
                                        <label for="item">Name of Item</label>
                                        <input type="text" class="form-control" id="item">
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label for="item_quantity ">Total Quantity</label>
                                        <input type="number" class="form-control" id="item_quantity">
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label for="item_per_person">Number of item to be claimed by individual</label>
                                        <input type="number" class="form-control" id="item_per_person">
                                    </div>
                                </div> 
                                <div class="form-row">
                                    <div class="col-md-6 mb-3">
                                        <label for="item_desc">Description</label>
                                        <textarea class="form-control" id="item_desc" rows="2" ></textarea>
                                    </div>
                                </div>
                            </div> 
                            <!-- Donation Information -->
                            <h4 class="h4 mb-2 mt-3">Donor Details</h4>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="name">Name (Company, Organization or Individual)</label>
                                    <input type="text" class="form-control" id="name" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="donor_type">Donor Type</label>
                                    <select id="donor_type" class="form-control" required>
                                        <option value="" disabled selected>Select</option>
                                        <option value="Individual">Individual</option>
                                        <option value="Organization">Organization</option>
                                        <option value="Company">Company</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="email">Email</label>
                                    <input type="email" class="form-control" id="email" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="phone">Phone Number</label>
                                    <input type="tel" class="form-control" id="phone" required>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="address">Address</label>
                                    <textarea class="form-control" id="address" rows="2" required></textarea>
                                </div>
                            </div>
                            <!-- Beneficiary Fields -->
                            <h4 class="h4 mb-2 mt-3">Beneficiary</h4>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="beneficiary">Beneficiary</label>
                                    <select id="beneficiary" class="form-control" required>
                                        <option value="" disabled selected>Select</option>
                                        <option value="PWD">Persons With Disability</option>
                                        <option value="Senior Citizen">Senior Citizen</option>
                                        <option value="Both">Both</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="allow_multiple">Allow multiple claim?</label>
                                    <select id="allow_multiple" class="form-control" required>
                                        <option value="" disabled selected>Select</option>
                                        <option value="No">No</option>
                                        <option value="Yes">Yes</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-12 mb-3">
                                    <label for="purpose">Purpose of Donation</label>
                                    <textarea class="form-control" id="purpose" rows="2" required></textarea>
                                </div>
                            </div>
                            <div class="form-row">
                                <button class="btn btn-primary btn-lg my-2" type="submit">Submit Request</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 
<?= endSection() ?> 
 

<!-- Start the java scripts for this page -->
<?= startSection('scripts') ?> 
<script >
    $(document).ready(function(){    
        getLocationList();

        $("#monetary_fields").hide();
        $("#material_fields").hide(); 

        $("#donation_type").on('change', function(){    
            if($(this).val()=="Monetary") {
                $("#monetary_fields").show();
                $("#material_fields").hide();
                $('#total_amount').attr('required', 'required'); 
                $('#total_beneficiary').attr('required', 'required');  
                $('#item').removeAttr('required'); 
                $('#item_quantity').removeAttr('required'); 
                $('#item_per_person').removeAttr('required'); 
                $('#item_desc').removeAttr('required'); 
            } else if($(this).val()=="Material") {
                $("#material_fields").show();
                $("#monetary_fields").hide();
                $('#item').attr('required', 'required');
                $('#item_quantity').attr('required', 'required');
                $('#item_per_person').attr('required', 'required');
                $('#item_desc').attr('required', 'required');
                $('#total_amount').removeAttr('required'); 
                $('#total_beneficiary').removeAttr('required'); 
            }
        }).change();

        $('#submitRequest').on('submit', function(e) {
            e.preventDefault();

            if (this.checkValidity()) {
                showLoader();
                var title   	        = $("#title").val();
                var schedule   	        = $("#schedule").val();
                var name   	            = $("#name").val();
                var email   	        = $("#email").val();
                var phone   	        = $("#phone").val();
                var address   	        = $("#address").val();
                var donor_type   	    = $("#donor_type").val();
                var donation_type   	= $("#donation_type").val();
                var total_amount   	    = $("#total_amount").val();
                var total_beneficiary   = $("#total_beneficiary").val();
                var item   	            = $("#item").val();
                var item_desc   	    = $("#item_desc").val();
                var item_quantity   	= $("#item_quantity").val();
                var item_per_person   	= $("#item_per_person").val();
                var beneficiary   	    = $("#beneficiary").val();
                var purpose   	        = $("#purpose").val();
                var location   	        = $("#location").val();
                var allow_multiple   	= $("#allow_multiple").val();
                
                var now = new Date();

                if(new Date(schedule) < now){ 
                    Swal.fire({
                        icon: "error",
                        title: "Invalid Schedule",
                        text: "Please choose a date that is at least tomorrow or later.",
                        confirmButtonText: "OK",
                        didOpen: () => {
                            Swal.hideLoading();
                        },  
                    });
                } else {  
                    $.ajax({
						url: '<?=$baseURL?>/controller/ctrl-events.php',
                        type: "POST",
                        contentType: "application/json",
                        data: JSON.stringify({ 
                            trans               : "addEventRequest",
                            title               : title,
                            schedule            : schedule,
                            name                : name,
                            email               : email,
                            phone               : phone,
                            address             : address,
                            donor_type          : donor_type,
                            donation_type       : donation_type,
                            total_amount        : total_amount,
                            total_beneficiary   : total_beneficiary,
                            item                : item,
                            item_desc           : item_desc,
                            item_quantity       : item_quantity,
                            item_per_person     : item_per_person,
                            beneficiary         : beneficiary,
                            purpose             : purpose,
                            location            : location,
                            allow_multiple      : allow_multiple
                        }), 
                        success: function(response) {
                            closeLoader();
                            if (response.response_code === "0") {
                                Swal.fire({
                                    icon: 'success',
                                    title: response.title,
                                    text: response.description,
                                    confirmButtonText: 'OK'
                                }).then((result) => {
                                    window.location.href = '<?=$basePath?>/';  
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: response.title,
                                    text: response.description,
                                    confirmButtonText: 'OK',
                                    didOpen: () => {
                                        Swal.hideLoading();
                                    },  
                                });
                            }
                        },
                        error: function(xhr, status, error) { 
                            Swal.fire({
                                icon: 'error',
                                title: 'Request Failed',
                                text: 'We encountered an error while processing your request. Please try again!',
                                confirmButtonText: 'OK',
                                didOpen: () => {
                                    Swal.hideLoading();
                                },  
                            });
                        }
                    });
                }
            } else {
                this.reportValidity();  
            }
        });


        function getLocationList(){
            $.ajax({
				url: '<?=$baseURL?>/controller/ctrl-global.php', 
                type: "POST",
                contentType: "application/json",
                data: JSON.stringify(
                    { 
                        trans: "getLocations" 
                    }
                ), 
                success: function(response) {
                    if (response.response_code === "0") {
                        var items = response.items;
                        var dropdown = $('#location');

                        // Clear existing options
                        dropdown.empty();
                        dropdown.append('<option value="" disabled selected>Select location</option>');

                        // Populate the dropdown with items
                        $.each(items, function(index, item) {
                            dropdown.append('<option value="' + item.location_description + '">' + item.location_description + '</option>');
                        });
                    }
                }
            });
        }

    });
</script> 
<?= endSection() ?> 