-- MySQL dump 10.13  Distrib 8.0.36, for Linux (x86_64)
--
-- Host: localhost    Database: senior
-- ------------------------------------------------------
-- Server version	8.0.36-0ubuntu0.20.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `access_level`
--

DROP TABLE IF EXISTS `access_level`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_level` (
  `access_level_id` bigint NOT NULL AUTO_INCREMENT,
  `access_level_desc` varchar(50) NOT NULL,
  `access_level_stat` int NOT NULL DEFAULT '1',
  `access_level_code` varchar(4) NOT NULL,
  `access_def` smallint DEFAULT '0',
  `dt_ts` datetime DEFAULT NULL,
  PRIMARY KEY (`access_level_id`)
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_level`
--

LOCK TABLES `access_level` WRITE;
/*!40000 ALTER TABLE `access_level` DISABLE KEYS */;
INSERT INTO `access_level` VALUES (1,'Admin',1,'1001',0,NULL),(114,'Administrator',1,'1',0,NULL),(115,'Users',1,'143',0,NULL);
/*!40000 ALTER TABLE `access_level` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_level_menu_navbar`
--

DROP TABLE IF EXISTS `access_level_menu_navbar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_level_menu_navbar` (
  `access_level_menu_id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint DEFAULT NULL,
  `nav_menu_id` bigint DEFAULT NULL,
  PRIMARY KEY (`access_level_menu_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12307 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_level_menu_navbar`
--

LOCK TABLES `access_level_menu_navbar` WRITE;
/*!40000 ALTER TABLE `access_level_menu_navbar` DISABLE KEYS */;
INSERT INTO `access_level_menu_navbar` VALUES (12140,114,1),(12142,115,1),(12143,115,292),(12292,1,1),(12293,1,204),(12294,1,205),(12295,1,206),(12296,1,207),(12297,1,208),(12298,1,209),(12299,1,211),(12300,1,232),(12301,1,234),(12302,1,295),(12303,1,308),(12304,1,309),(12305,1,310),(12306,1,311);
/*!40000 ALTER TABLE `access_level_menu_navbar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `events`
--

DROP TABLE IF EXISTS `events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `schedule` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` text,
  `donor_type` enum('Individual','Organization','Company') DEFAULT NULL,
  `donation_type` enum('Material','Monetary') DEFAULT NULL,
  `total_amount` double DEFAULT NULL,
  `total_beneficiary` int DEFAULT NULL,
  `amount_per_person` double DEFAULT NULL,
  `amount_claimed` double DEFAULT '0',
  `item` text,
  `item_desc` text,
  `item_quantity` int DEFAULT NULL,
  `item_per_person` int DEFAULT '1',
  `item_claimed` int DEFAULT '0',
  `beneficiary` enum('PWD','Senior Citizen','Both') DEFAULT NULL,
  `purpose` text,
  `location` varchar(255) DEFAULT NULL,
  `allow_multiple` enum('Yes','No') CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` enum('Pending','Started','Done') CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `events`
--

LOCK TABLES `events` WRITE;
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
INSERT INTO `events` VALUES (1,'Mayor Pantawid Mahirap','2024-10-30 14:00:00','Vic Sotto','vic@gmail.com','02154211111','Pasig City','Individual','Material',0,0,0,0,'Wheelchair','For person with mobility problem',500,1,0,'Both','For people with mobility problem','Tayabas','Yes','Started','2024-10-22 11:52:41','2024-10-22 11:52:41'),(2,'Malasakit Foundation','2024-10-25 13:00:00','KKP','kkp@gmail.com','0154212222222','Tayabas','Organization','Monetary',50000,100,500,0,'','',0,0,0,'PWD','Pantawid gutom','Tayabas','No','Started','2024-10-22 12:50:58','2024-10-22 12:50:58'),(3,'Kabayan Foundation','2024-10-28 15:00:00','Armando Marcos','arman@gmail.com','09302222221','Coliling, San Carlos City','Individual','Material',0,0,0,0,'Hearing Aid','For hearing loss problem',200,1,0,'Senior Citizen','For the people of Coliling','San Carlos City','No','Started','2024-10-22 17:32:41','2024-10-22 17:32:41'),(4,'Senior Gantimpala','2024-10-28 12:00:00','Frizer','frizer@gmail.com','09303565452','Pasig City','Company','Material',0,0,0,0,'Vitamins','For Health',10000,5,0,'Both','Para sa ikakaganda ng kalusugan','Tayabas','No','Started','2024-10-23 03:47:25','2024-10-23 03:47:25'),(5,'Pasig Citizen','2024-10-27 15:00:00','Citizen Charter V','ctc@gmail.com','01254211111','Pasig City','Organization','Monetary',50000,10,5000,0,'','',0,0,0,'Senior Citizen','For citizen incentives','Tayabas','Yes','Started','2024-10-23 03:55:03','2024-10-23 03:55:03'),(6,'Manila Foundation','2025-01-01 10:10:00','Prizer','prizer@gmail.com','04962052','sample','Company','Material',0,0,0,0,'Paracetamol','This is for health',1000,2,0,'Senior Citizen','For people of Manila','Montalban','Yes','Pending','2024-10-27 16:28:48','2024-10-27 16:28:48');
/*!40000 ALTER TABLE `events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `locations`
--

DROP TABLE IF EXISTS `locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `locations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `location_description` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `locations`
--

LOCK TABLES `locations` WRITE;
/*!40000 ALTER TABLE `locations` DISABLE KEYS */;
INSERT INTO `locations` VALUES (1,'01','San Carlos City','2024-10-06 08:53:29'),(2,'02','Tayabas','2024-10-06 09:48:40'),(3,'03','Montalban','2024-10-06 09:50:03');
/*!40000 ALTER TABLE `locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `material_items`
--

DROP TABLE IF EXISTS `material_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `material_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `item_description` text NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `material_items`
--

LOCK TABLES `material_items` WRITE;
/*!40000 ALTER TABLE `material_items` DISABLE KEYS */;
INSERT INTO `material_items` VALUES (1,'01','Wheelchairs','Wheelchairs','2024-10-08 18:08:40'),(2,'02','Hearing Aid','Hearing Aid','2024-10-10 15:25:18'),(3,'03','White Cane','White Cane','2024-10-11 06:17:04'),(4,'04','Hospital Bed','This for person with back injury','2024-10-25 11:05:40'),(5,'05','Blood glucose meter','A small device called a glucose meter or glucometer measures how much sugar is in the blood sample. ','2024-10-27 16:07:46');
/*!40000 ALTER TABLE `material_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `member`
--

DROP TABLE IF EXISTS `member`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `member` (
  `id` int NOT NULL AUTO_INCREMENT,
  `doc_number` varchar(64) NOT NULL,
  `fname` varchar(64) DEFAULT NULL,
  `mname` varchar(64) DEFAULT NULL,
  `lname` varchar(64) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `location_st` varchar(64) DEFAULT NULL,
  `location_brgy` varchar(64) DEFAULT NULL,
  `location_city` varchar(64) DEFAULT NULL,
  `location_prov` varchar(64) DEFAULT NULL,
  `location_region` varchar(64) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` enum('Active','Inactive') DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `member`
--

LOCK TABLES `member` WRITE;
/*!40000 ALTER TABLE `member` DISABLE KEYS */;
INSERT INTO `member` VALUES (2,'123456789','CORAZON','','CRUZ','2004-10-07','corazon@gmail.com','0932654987','Bonifacio','Valencia','Tayabas','Quezon','Quezon',NULL,NULL,'2024-10-07 11:42:52','2024-10-23 06:18:49');
/*!40000 ALTER TABLE `member` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `member_claimed`
--

DROP TABLE IF EXISTS `member_claimed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `member_claimed` (
  `id` int NOT NULL AUTO_INCREMENT,
  `reference` varchar(255) NOT NULL,
  `member_id` int DEFAULT NULL,
  `origin` enum('Event','Request') CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT 'Event - event table,\r\nRequest - request table\r\n',
  `origin_id` int DEFAULT NULL,
  `donation_type` enum('Material','Monetary') DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `item_quantity` int DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `claimed_date` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `member_claimed`
--

LOCK TABLES `member_claimed` WRITE;
/*!40000 ALTER TABLE `member_claimed` DISABLE KEYS */;
/*!40000 ALTER TABLE `member_claimed` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request`
--

DROP TABLE IF EXISTS `request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `request` (
  `id` int NOT NULL AUTO_INCREMENT,
  `member_id` int DEFAULT NULL,
  `donation_type` enum('Material','Monetary') DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `item_quantity` int DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `purpose` text,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` enum('Pending','Verified','Approved','Denied','Claimed') CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `verified_date` datetime DEFAULT NULL,
  `verified_by` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `denied_date` datetime DEFAULT NULL,
  `denied_by` varchar(255) DEFAULT NULL,
  `approved_date` datetime DEFAULT NULL,
  `approved_by` varchar(255) DEFAULT NULL,
  `claimed_date` datetime DEFAULT NULL,
  `claimed_by` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `released_date` datetime DEFAULT NULL,
  `released_by` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request`
--

LOCK TABLES `request` WRITE;
/*!40000 ALTER TABLE `request` DISABLE KEYS */;
INSERT INTO `request` VALUES (1,123456789,'Material',2,1,NULL,'This is a test','Tayabas','Approved','2024-10-24 05:52:02','28',NULL,NULL,'2024-10-24 06:24:41','28',NULL,NULL,NULL,NULL,'2024-10-24 00:17:44','2024-10-25 10:00:57'),(2,123456789,'Material',2,1,NULL,'Donation Details','Montalban','Verified','2024-10-24 06:24:32','28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-24 00:32:01','2024-10-23 22:24:35'),(3,123456789,'Monetary',0,0,1000,'Senior care','San Carlos','Pending',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-24 00:59:56','2024-10-23 18:34:15'),(4,123456789,'Material',3,1,NULL,'For personal','Tayabas','Approved','2024-10-24 06:36:46','28',NULL,NULL,'2024-10-24 15:38:50','28',NULL,NULL,NULL,NULL,'2024-10-24 01:11:49','2024-10-25 10:00:51'),(5,123456789,'Material',3,1,NULL,'For family','San Carlos City','Pending',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-25 18:19:45','2024-10-25 10:19:45'),(6,123456789,'Material',4,1,NULL,'for illness','San Carlos City','Pending',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-27 17:26:21','2024-10-27 15:26:21'),(7,123456789,'Material',2,1,NULL,'for hearing aid','Montalban','Pending',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-27 17:28:47','2024-10-27 15:28:47'),(8,123456789,'Monetary',0,0,10000,'operations of kidney','San Carlos City','Pending',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-27 17:46:30','2024-10-27 15:46:30'),(9,123456789,'Material',3,1,0,'seek of me','San Carlos City','Pending',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-27 17:49:36','2024-10-27 15:49:36');
/*!40000 ALTER TABLE `request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_members`
--

DROP TABLE IF EXISTS `tbl_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_members` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fname` varchar(225) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `mname` varchar(225) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `lname` varchar(225) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `complete_address` varchar(1225) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `house_no` varchar(225) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `street` varchar(225) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `brgy` varchar(225) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `city` varchar(225) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `province` varchar(225) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `zip_code` varchar(225) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `contact_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `image` longblob NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_members`
--

LOCK TABLES `tbl_members` WRITE;
/*!40000 ALTER TABLE `tbl_members` DISABLE KEYS */;
INSERT INTO `tbl_members` VALUES (1,'Rommel','Cayabyab','Santiago','436 Oplas, Bacnar, San Carlos City, Pangasinan','436','Oplas','Bacnar','San Carlos City','Pangasinan','2420','09384547619',_binary 'ÿØÿà\0JFIF\0\0H\0H\0\0ÿâ ICC_PROFILE\0\0\0lcms0\0\0mntrRGB XYZ Ý\0\0\Z\0\0\00acspAPPL\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0öÖ\0\0\0\0\0Ó-lcms\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0desc\0\0\0\0\08cprt\0\0@\0\0\0Nwtpt\0\0\0\0\0chad\0\0¤\0\0\0,rXYZ\0\0Ð\0\0\0bXYZ\0\0ä\0\0\0gXYZ\0\0ø\0\0\0rTRC\0\0\0\0\0 gTRC\0\0,\0\0\0 bTRC\0\0L\0\0\0 chrm\0\0l\0\0\0$mluc\0\0\0\0\0\0\0\0\0\0enUS\0\0\0\0\0\0\0s\0R\0G\0B\0 \0b\0u\0i\0l\0t\0-\0i\0n\0\0mluc\0\0\0\0\0\0\0\0\0\0enUS\0\0\02\0\0\0\0N\0o\0 \0c\0o\0p\0y\0r\0i\0g\0h\0t\0,\0 \0u\0s\0e\0 \0f\0r\0e\0e\0l\0y\0\0\0\0XYZ \0\0\0\0\0\0öÖ\0\0\0\0\0Ó-sf32\0\0\0\0\0J\0\0ãÿÿó*\0\0›\0\0ý‡ÿÿû¢ÿÿý£\0\0Ø\0\0À”XYZ \0\0\0\0\0\0o”\0\08î\0\0XYZ \0\0\0\0\0\0$\0\0ƒ\0\0¶¾XYZ \0\0\0\0\0\0b¥\0\0·\0\0Þpara\0\0\0\0\0\0\0\0ff\0\0ò§\0\0\rY\0\0Ð\0\0\n[para\0\0\0\0\0\0\0\0ff\0\0ò§\0\0\rY\0\0Ð\0\0\n[para\0\0\0\0\0\0\0\0ff\0\0ò§\0\0\rY\0\0Ð\0\0\n[chrm\0\0\0\0\0\0\0\0\0£×\0\0T{\0\0LÍ\0\0™š\0\0&f\0\0\\ÿÛ\0C\0	\Z!\Z\"$\"$ÿÛ\0CÿÀ\0\0€\0€\"\0ÿÄ\0\0\0\0\0\0\0\0\0\0\0\0\0\0ÿÄ\09\0\0\0\0\0\0!1aAQ\"q2‘¡±#RbÁÑð$3ráñÿÄ\0\Z\0\0\0\0\0\0\0\0\0\0\0\0\0ÿÄ\0#\0\0\0\0\0\0\0\0\01!AQ\"2aÿÚ\0\0\0?\0nTß¥S~•Ú¦J*¦ý(B©¿J\"§®(©ô@˜*°<€SGëú^l&ÔnV>|„\\îÇµ‹øªÇ@Œ£/Ÿs¶\"S¾H$gÛ¥Q\\Y©^ñºo&Q<¤”Ž4ÝPz\0Z®H$›8ÇµMeÞ\r>Y`µ\0¶Ëñ·rßâ¢—S^o0·’c¼¯+ó±ïÊˆ–7°r­Í¬Ðçà\n’ró¹Ècò¥·žVŸ¹ŽPÑ9S”g=÷o}‡Ö‡\\t4~ó¿Ž&´–0AÛ”¦3ïõ¥š³ªX¹}7P¹—ï >Ÿ#±Å÷Zyb6’ébÈnU\\cÜîr\r7ÁpÖÌs	Œß`}ÁuïVS-ñg™,uß-_<¿hQ…\'Ð‘íúU“Ê]ÁßjÌ\Z¤‹ç ,ŒqŸ1GÞù±ùŠ¸üâªé£Ý¾níb,wx¿¾:|±D€då£ ºv§n”®Õ6PÝ,}©4‘ö§\'®ÔžX¶5D‘;Wj½«µ]ºQqéP‡( W’|\nXíE“°¦®0¸{>»•HVòÈúU¶EâN¢ÚOäHO!åb::‘ó¦=?N¿¹Ÿ±ˆã;|ñ¿áOš4êñäåó±$ž`sþæµ\'…|¤„^X#Ë\"†Ë¨Êzúú×ù?‹¤0ÆÆü¯É•a°Òm] »†óÃCw\0î1ß¯jgÒ&®$·øàlçú{m[·TðÃ‡ïÔ5Æ	À\07.õ×¼ÐþÑh¦&ÆêVPÍñåøæúfTÔ2ÊÈƒÎ—dE!;¶}Î;Ó]ì¹ŒÅÌ{Œ7Î´ž±á‰DòUp«°\0T]ðîHÖå8ô;UÃ6;ÑŸ4¶ŠY²@+ÐíKxkX¸ÐuÛ]RØ±0È	\\ã™}TüÆÔé¯è÷\ZsºHOuÍ0Íä,r={ÓX¤¶…Ó­Áéš¿L»ƒSÓmïí_žãYö\"ŠéÚ¡]ÉuÀK§?f¸x×MˆýMO™}èŒ„.©4±ö§NÔšUØíVˆ=*íÒˆªzb»TíEHúmP°A7éQ ¹—†Y!<£›.Onƒêjr‘ôÚ˜¼Dµð•ï6\0HùŽ}Þ†]Ê7€Þ+}jÞTq5Ú¨}±·âÖàáØ#M6\0ª6QÐmÒ°f—ÍÆ:,q¿‰dÜÉŒ˜#ð­ë M\nÛ¬M*)¦w¤Ù‰òCÌ”Xêïü\";Slòs1·éK¤šL3ŸcHY£Ç9•‡ha“PŸ9QëQmFÂ9$bÈ¤Žµ,Ô.àÁ\\ãÞ£\ZµõœÉ+L |ëØm¤¼”¯‰zS} C\n“¾Qp›iäÁC‚+Dñü7WRy2¬‹œäzUÆÑ8’ðFFç:m…\'ü±|Wô‹[öp~}VBv[” |×ÿ\0Ui²œÕIû6M‡Uƒ ;º:®z€0játíLØ­¦»:ö¤Ò¦GJ_\"gÒ“Ê¨#ðµv‰ÚŒ±Ñ‘;TGÚ…¨ØÛßYKiw™ŠU×ÜRôjõ¡æ{íTËfw½ðúçEñWDˆ>læ¿ŽHK}àªàŒüñW7Ý>™©¼->©=õë&ÞÆ YsÓ,p w&8§‚ï5­_†õý>â5“L˜Íp²‰T•8tÀ›`ã­X÷\ZdWq‰\n§7¡(\r ²ç´Ÿ£ÒWB‹|zfnÐ¸ƒŒï5ÙbÓ¿,VÎÅÜ‘‘ŸåÀ\0ç|àõ«ÛK›PNkíDrÜF»¯µ.;j.…ÝÃ´Ž»€#ãYÌ<+rP`Èq·µgd”¥àëª\r-7ëZæ¿¯5Žž×$JøTùù·§½5Ëk¨i:Î™¨ðÍõÜ–ËÍ%ÀÔX¡?tm¾ÇÖ¬n´·ŽñZ5RÄaˆ;üL®´®bìDg¶3G”V´c<w7½™þÎpMÍ¤C\rãuÝqUw‰¥8’CÔÌŠËøcûV¨â.ÊÊÝ’\0\0sß>µKqVŒo¤yí-£’ô…Š7s²&Ib;â·Ç»Œù3“\'’âÁØ!MK’ÑyH†H¦ÇF ŸÏò«´¯¸ªûÂŽ:v¢ÄÉDy„ý÷ldÿ\0o¥Y›t¦X¾`ßØ³;Jj+Ò:Œt¤òÇÚ–8>Ô)Wojèèá$q§j* Ú\'j\"&ý*‚9Pq]\"dô¢„\0W¡Gµ^ˆ‡=7W[M5í¤·iOÅÈCŒúSÍ…üQÚ#9Ü/CQ`¾ôª{Y.tò-¤äy§`i>}j¦§cÏŽºSý%è¼As¬kígb¤Û[ÊbÇÑi£‹ø×L·áò—–s[Ü¨eû<ÉÊÜÙÇËZ5¦ x`%¤\\=w4ê­s.‹9\' g×¥)âpÚ…‘kî\r’ñ\"•‘•À©Èù×#ÉmÜ½tRñÙh.,m$ŽàOÌãlúUÉ¥q$Wšdb\\$Á~$>½ê­A¨ii5ËpÊØB¼Ç–iqË‚@ÆIûÂ–p;ëºí¬­{£>´î±Ï^ÂŽQZÚI¯È.6Õ£g1Æw9ü*¾ŽÞþ÷^Ótû^EYå=Šç•rH©WÛÆº¾¤Ñ·4Q7–Œ}O­ÃÛ%—Pžù—þÊyi·«uü…oˆ”æ¿2n1m2I¥é–úm ‚ÝN:³¬}Í(e$t¥,£(L zSÄ’ZGŸ”œžØ’Eí@‘}Å+”RyéT	)@6Úˆ»í^F3µf Gª§Ú§jô]¿½@´x”[kƒr±þƒìÕà¯Š+)VPAêµc‘R¶\r3l{SRCìF	m¹•ÆàŽ´Ç¨Ãkd’$)<~bâNFÀaìiU„ÇO½KK¦&	F`”úIÿ\04ç{»Æ9™[>™¤0rƒÔUi\\j–ëuvn¥W–Br^MÎÑC½Ö×M³‘¢?\Z¡ÿ\0äv©ÜÚYÚ73Æ>÷N•GñO	îJ@ÙP}=ýêiÉ—}ÿ\0bvù¶ÌÙ/#3µ3ðí\"<6²FÊîÒ·™ƒžV=ÀÅT\rt?‰ss(ÆÈìvQI<ñ&ÛFâJßZœÁ¤ê’ù©#Dtû)]‰ôÀ4Ë¿Ù¿¡}»Š_f‰qŒÐ\\mG%]C+VV ƒê(rS1[Ê£Ú“Ê£ªJM ØÔì¢S@h©÷¨0…\"¨$uÅìh`oš*Ÿ„T÷ÅÇºÀÐ8KPÔ×ic„ˆ{ÈÛ/æi\'ñï\rðÂ•¿¾W¹ÇÃmÇ!úz}j˜ñÄ‹®/²û\nY­•ŠJüÒ1\0ã›ÓéGòzRÑ£ô;¸uŽÒµDžÚ7}½Ôgó¦®&ÒuKhš}#T“ËÆDrŽ`>½j\'û6ë}À²èW‡zUÄ–ì¯/1e?©Æ«ãÀ`‰Ï”Û³^jÕÆMŠ¦ø¢ŠãúŠâá£¾¿2(?r1P»ûk›HÞY‘d³mŠ¾õ­N±µ–ÿ\0Qš;{x—šId8ÿ\0ZÏ^%ñ\'ïË£mcÙôØÏÀ‡f“ú›üWV½ø^>Î|»áJÛ~H§k“j‹8IKU9luûžÞÂ£­qÊrqJæÙùhöväÄÓÈ\näzúÓØ×\ZãÆ\")Ù+%¹^$Emo	ñáO%…ÓŸ…AéAü§è}*ð–±‡=d\rö«ÃÏ5.‚-7XŠMOOS„nãB¸è¤ìËØý\rišAI¥èiqVƒÄ	tF)ßhOÃ*|ÔïømK¦ÜTBIéGYG3°P:’iœ‘BÒHÁQAbO@+;ø‘ÆúkÛZ\\K•nå\"¯˜GVo~ÕØMè¼8—Ä~Ð‘–Kõ»¸\\ÿ\0Ûã9ö\' üj ã8Zç·ÓˆÒ¬Û ,G2°îÞŸLT#P¡1ò¯2ªÌ8éF¢rl³3´²±g;–c“Ÿ1q>±sfñÙÙÉå±^y\\\ròzô§Ï-¤‘SpXïP½i¾Õ|òF3æÈy²/Â?J4Úèf‹ðóQ›CÕ¸sŠ6Oâ+8\"¸ß N¨·Ô©úÕ×Å\\AaÃš4Úž©uÑ®Abcè«îO ¬£á†±}h–ü9rÆçM¸eÿ\0Žçx]›<ñ“÷N@>Æ¤_´.·}{û®6Ä‘é73Z]Fê\Z3<l2HèAQ·ÈŠSn•ë}c––?$¿Á\'qí÷J·\r*¦ž¬M½º„wovïééPMF~Prqšf¶ÖfMIÞwiføö€ÐcÛÚ”ß3I1\réNªã\nÔb´#±ÊSå\'ØšÞ7¸» ËHÜª;š‘^Û-²Çjƒ\"1Œû÷ ð¥ŠËp÷-ËËÂ ÿ\01õü)ÖþØ‰‰ß©9¬äC:Fqÿ\0\Zæ8¿äò÷S\'>çÿ\0”½ã—úú×–psÜNäôlvØgûšÄŠ’A<w6Ò½´Ñœ¤‘±R§±?á_5\0–|K_@6q€&QýC£~GçP¹“— ŽeßâM\"ÿÙ',0),(2,'Rommel','Cayabyab','Santiago','436 Oplas, Bacnar, San Carlos City, Pangasinan','436','Oplas','Bacnar','San Carlos City','Pangasinan','2420','09384547619',_binary 'image.jpg',0),(3,'Rommel','Cayabyab','Santiago','436 Oplas, Bacnar, San Carlos City, Pangasinan','436','Oplas','Bacnar','San Carlos City','Pangasinan','2420','09384547619',_binary 'image.jpg',0),(4,'asdasdas','asdas','',' , , , ','','','','','','','','',0),(5,'dsa','','',' , , , ','','','','','','','','',0),(6,'dsa','','',' , , , ','','','','','','','','',0),(7,'Rommel','Cayabyab','Santiago','436 Oplas, Bacnar, San Carlos City, Pangasinan','436','Oplas','Bacnar','San Carlos City','Pangasinan','2420','09384547619',_binary 'image.jpg',0),(8,'sASasASa','','',' , , , ','','','','','','','','',0),(9,'','','',' , , , ','','','','','','','','',0),(10,'','','',' , , , ','','','','','','','','',0),(11,'','','',' , , , ','','','','','','','','',0),(12,'','','',' , , , ','','','','','','','','',0),(13,'','','',' , , , ','','','','','','','','',0),(14,'','','',' , , , ','','','','','','','','',0),(15,'','','',' , , , ','','','','','','','','',0),(16,'ASasA','','',' , , , ','','','','','','','','',0),(17,'123asdadassa','','',' , , , ','','','','','','','','',0);
/*!40000 ALTER TABLE `tbl_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_menu_list`
--

DROP TABLE IF EXISTS `tbl_menu_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_menu_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `link` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `parentid` int DEFAULT NULL,
  `remarks` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=312 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_menu_list`
--

LOCK TABLES `tbl_menu_list` WRITE;
/*!40000 ALTER TABLE `tbl_menu_list` DISABLE KEYS */;
INSERT INTO `tbl_menu_list` VALUES (1,'Dashboard','/',0,'','fe fe-home fe-16'),(204,'User','#',295,NULL,'fe fe-user fe-16'),(205,'Add User','add-user.php',204,NULL,'fe fe-minus fe-16'),(206,'List User','list-user.php',204,NULL,'fe fe-minus fe-16'),(207,'Modify User Level','add-access-menu.php',204,NULL,'fe fe-minus fe-16'),(208,'Access Level','#',295,NULL,'fe fe-trello fe-16'),(209,'Add User Access Level','add-user-level.php',208,NULL,'fe fe-minus fe-16'),(211,'View User Access Level','list-accesslvl.php',208,NULL,'fe fe-minus fe-16'),(232,'Dynamic Menu','#',295,'Good','fe fe-menu fe-16'),(234,'List Dynamic Menu','list_of_dynamic_menu.php',232,'Good','fe fe-minus fe-16'),(292,'Members','philhealth_members_view.php',0,'Good','fe fe-check-square fe-16'),(293,'Reports','report_issue_voters.php',0,'Good','fe fe-file-text fe-16'),(294,'Logs','logs_voters_issued.php',0,'Good','fe fe-book-open fe-16'),(295,'User Management','#',0,'Good','fe fe-settings fe-16'),(305,'List of Donation','#',0,'Parent',NULL),(306,'Verify Request','list_verify_request.php',305,'Child',NULL),(307,'Request Donation','#',0,'Parent',NULL),(308,'Donation','#',0,'Parent','fe fe-git-pull-request fe-16'),(309,'Item List','items',308,'Child','fe fe-check fe-16'),(310,'Approve Request','list_for_approval_request.php',308,'Child','fe fe-check-circle fe-16'),(311,'List of Request Donation','list_request.php',308,'Child','fe fe-list fe-16');
/*!40000 ALTER TABLE `tbl_menu_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_users`
--

DROP TABLE IF EXISTS `tbl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_users` (
  `idno` int NOT NULL AUTO_INCREMENT,
  `uname` varchar(255) DEFAULT NULL,
  `userpass` varchar(255) DEFAULT NULL,
  `userempidno` varchar(15) DEFAULT NULL,
  `userfname` varchar(255) DEFAULT NULL,
  `userlname` varchar(255) DEFAULT NULL,
  `userposition` varchar(255) DEFAULT NULL,
  `userrole` varchar(255) DEFAULT NULL,
  `useroffice` varchar(255) DEFAULT NULL,
  `officeid` varchar(10) DEFAULT NULL,
  `userstatus` varchar(255) DEFAULT NULL,
  `userdatereg` varchar(255) DEFAULT NULL,
  `useremail` varchar(255) DEFAULT NULL,
  `access_level_cde` varchar(6) DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `android_user` int DEFAULT NULL,
  `reset_pwd` smallint DEFAULT '0',
  PRIMARY KEY (`idno`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_users`
--

LOCK TABLES `tbl_users` WRITE;
/*!40000 ALTER TABLE `tbl_users` DISABLE KEYS */;
INSERT INTO `tbl_users` VALUES (28,'Admin@Admin.com','$2y$10$6hSlrq.DUmQU./T.VlCqsOi/abwZdM.Dr4gZebmVIgZy67GN0x6a6','1001','Rommel','Santiago','Admin','1','Admin',NULL,'1','2024-02-23 19:07:30','Admin@Admin.com','1',NULL,0,1),(29,'user@gmail.com','$2y$10$rniUUvIO2p.TtZW4iQAGVu5ZUaaICz0kDXnU5vFWMimyCY9YQEPkK','1002','Rommel','Santiago','Staff','115','Staff',NULL,'1','2024-03-07 21:30:04','user@gmail.com','115',NULL,0,1),(30,'','$2y$10$UPS45hGYY00ZaQuK3dfk5OW45i9.jq91fbvmfBdkOpcY1YmX3nxsW','','','','','','',NULL,'1','2024-03-05 19:41:07','','',NULL,0,1),(31,'Admin@Admin.admin','$2y$10$xU6K.oloHNkiui5/zknYWuUhZPnajwfQqnbT.6b/xIBsGzESRepxW','','','','','','',NULL,'1','2024-03-05 19:42:35','Admin@Admin.admin','',NULL,0,1),(32,'user@gmail.com456','$2y$10$115O26L/8rDml3hgMlIKn.DiYs7nXbCWzAZAmxHRGLYP.59wQMnWa','3','Jet','Santiago','User','','User',NULL,'1','2024-03-06 21:47:58','user@gmail.com456','',NULL,0,1),(33,'user@gmail.com123','$2y$10$UfuG9DvUNXYvz91DcW/NGuBHpeRdQH2anthjlB.eOoGMhiTK4E.Hm','1003','Rommel','Santiago','User','','User',NULL,'1','2024-03-06 21:48:11','user@gmail.com','',NULL,0,1),(34,'Admin@Admin.com.ph','$2y$10$KYwO7hg5OIxum28Plzk/WOkZ0YAD3fB.dfUSM2SzDsFptjnMoCL8u','1004','Rommel','Santiago','Admin','1','Admin',NULL,'1','2024-03-05 20:13:44','Admin@Admin.com.ph','1',NULL,0,1);
/*!40000 ALTER TABLE `tbl_users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-11-20 16:08:01
