<?php

    // Include routes and functions
    // require 'routes.php';
    require 'functions.php';
    require 'sections.php';
	
    // Load env file
    $ENV = parse_ini_file('.env'); 
		
	$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

	// Split the URI into segments
	$segments = explode('/', trim($uri, '/'));

	// Find the position of 'index.php' in the array
	$indexPosition = array_search('index.php', $segments);

	// Get the segment after 'index.php' if it exists
	$route = isset($segments[$indexPosition + 1]) ? $segments[$indexPosition + 1] : '';
	
	$protocol 	= (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') ? "https" : "http";
	
	$baseURL 	= $protocol . "://" . $_SERVER['HTTP_HOST'].'/senior';
	$basePath 	= $protocol . "://" . $_SERVER['HTTP_HOST'].'/senior/index.php';
	
	switch ($route) {
		case '':
		case '/':
		case 'events':
			require_once 'views/events.php';
			break;

		case 'create-events':
			require_once 'views/create-events.php';
			break;

		case 'request':
			require_once 'views/request.php';
			break;

		case 'create-request':
			require_once 'views/create-request.php';
			break;

		case 'create-request-member':
			require_once 'views/create-request-member.php';
			break;

		case 'request-approval':
			require_once 'views/request-approval.php';
			break;

		case 'items':
			require_once 'views/items.php';
			break;

		case 'create-items':
			require_once 'views/create-items.php';
			break;

		case 'items':
			require_once 'views/items.php';
			break;

		default:
			http_response_code(404);
			require_once 'views/404.php';
	}
	 
    // Load template layout
    require 'views/layout.php';