<?php
	include_once __DIR__ . '/../config/dbconn.php';
	date_default_timezone_set('Asia/Manila');

	// Get JSON input
	$json = file_get_contents('php://input');
	$data = json_decode($json);
	
	// // Get post data
	$trans = $data->trans;

	if ($trans === "getLocations") {
		$sql = "SELECT code, location_description
				FROM locations 		
				ORDER BY location_description ASC ";
		 
		// Execute the query
		$runQuery = mysqli_query($con, $sql);
		$count_rows = mysqli_num_rows($runQuery);

		// If rows are found, return them as JSON
		if ($count_rows > 0) {
			$results = [];
			while ($record = mysqli_fetch_assoc($runQuery)) {
				$results[] = $record;
			}

			// Creating the response object
			$response = new stdClass();
			$response->items = $results;
			$response->title = 'Successful';
			$response->description = 'Request successful!';
			$response->response_code = "0";
		} else {
			// If no items are found
			$response = new stdClass();
			$response->title = 'Failed';
			$response->description = 'No record found!';
			$response->response_code = '2';
		}
		
	} else if ($trans === "getMaterialItems") {
		$sql = "SELECT id, code, title, item_description
				FROM material_items 		
				ORDER BY title ASC ";
		 
		// Execute the query
		$runQuery = mysqli_query($con, $sql);
		$count_rows = mysqli_num_rows($runQuery);

		// If rows are found, return them as JSON
		if ($count_rows > 0) {
			$results = [];
			while ($record = mysqli_fetch_assoc($runQuery)) {
				$results[] = $record;
			}

			// Creating the response object
			$response = new stdClass();
			$response->items = $results;
			$response->title = 'Successful';
			$response->description = 'Request successful!';
			$response->response_code = "0";
		} else {
			// If no items are found
			$response = new stdClass();
			$response->title = 'Failed';
			$response->description = 'No record found!';
			$response->response_code = '2';
		}
		
	} else if ($trans === "verifyCardId") {
		$member_id = isset($data->member_id) ? $data->member_id : '';

		$sql = "SELECT *
				FROM member 
				WHERE doc_number = '$member_id'	
				LIMIT 1 ";
		 
		// Execute the query
		$runQuery = mysqli_query($con, $sql);
		$count_rows = mysqli_num_rows($runQuery);

		// If rows are found, return them as JSON
		if ($count_rows > 0) {
			$record = mysqli_fetch_assoc($runQuery); 

			// Creating the response object
			$response = new stdClass();
			$response->results = $record;
			$response->title = 'Successful';
			$response->description = 'Request successful!';
			$response->response_code = "0";
		} else {
			// If no items are found
			$response = new stdClass();
			$response->title = 'Failed';
			$response->description = 'No record found!';
			$response->response_code = '2';
		}
		
	} else {
		// If invalid trans value
		$response = new stdClass();
		$response->title = 'Critical Error!';
		$response->description = 'Invalid transaction.';
		$response->response_code = '1';
	}

	// Send the response as JSON
	header('Content-Type: application/json');
	echo json_encode($response);
?>
