<?php
	include_once __DIR__ . '/../config/dbconn.php';
	date_default_timezone_set('Asia/Manila');

	// Get JSON input
	$json = file_get_contents('php://input');
	$data = json_decode($json);
	
	// Get post data
	$trans = $data->trans;

	if ($trans == "addEventRequest") {
		// Extract fields from the decoded JSON 
		$title 				= $data->title;
		$schedule			= $data->schedule;
		$name 				= $data->name;
		$email 				= $data->email;
		$phone 				= $data->phone;
		$address 			= $data->address;;
		$donor_type 		= $data->donor_type;
		$donation_type 		= $data->donation_type;
		$total_amount 		= $data->total_amount;
		$total_beneficiary	= $data->total_beneficiary;
		$item 				= $data->item;
		$item_desc 			= $data->item_desc;
		$item_quantity 		= $data->item_quantity;
		$item_per_person	= $data->item_per_person;
		$beneficiary 		= $data->beneficiary;
		$purpose 			= $data->purpose;
		$location 			= $data->location;
		$allow_multiple		= $data->allow_multiple;

		// Default status for new request
		$status = "Pending"; 
		if($donation_type=="Material"){
			$total_amount = 0;
			$total_beneficiary = 0;
			$amount_per_person = 0; 
		} else {
			$amount_per_person 	= $total_amount / $total_beneficiary;
			$item = '';
			$item_desc = '';
			$item_quantity = 0;
			$item_per_person = 0;
		}

		// Prepare SQL query for inserting donation request
		$sql = "INSERT INTO events 
				( 
					title, name, schedule, email, phone, address, donor_type, donation_type, total_amount, total_beneficiary, amount_per_person, item, item_desc, item_quantity, item_per_person, beneficiary, purpose, location, allow_multiple, status, created_at
				) VALUES (
					'$title', '$name', '$schedule', '$email', '$phone','$address', '$donor_type', '$donation_type', '$total_amount', '$total_beneficiary', '$amount_per_person', '$item', '$item_desc', '$item_quantity', '$item_per_person', '$beneficiary', '$purpose', '$location', '$allow_multiple', '$status', Now()
				)";

		// Execute the query
		if (mysqli_query($con, $sql)) {
			$response = new stdClass();
			$response->title = 'Request Successful';
			$response->description = 'Your request has been processed successfully!';
			$response->response_code = '0';
		} else {
			$response = new stdClass();
			$response->title = 'Request Failed';
			$response->description = 'We encountered an error while processing your request. Please try again!';
			$response->response_code = '3';
		} 

	} else if ($trans === "getDonationEvents") { 
		
		// Extract fields from the decoded JSON
		$status = isset($data->status) ? $data->status : '';
		$donation_type = isset($data->donation_type) ? $data->donation_type : '';
		$location = isset($data->location) ? $data->location : '';
			
		// Prepare the SQL query
		$sql = "SELECT * 
				FROM events 
				WHERE status <> '' ";
		if($status!=''){
			$sql .= " AND status = '$status' ";
		}
		if($donation_type!=''){
			$sql .= " AND donation_type='$donation_type' ";
		}
		if($location!=''){
			$sql .= " AND location='$location' ";
		}
		$sql .= " ORDER BY created_at DESC";

		// Execute the query
		$runQuery = mysqli_query($con, $sql);
		$count_rows = mysqli_num_rows($runQuery);

		// If rows are found, return them as JSON
		if ($count_rows > 0) {
			$results = [];
			while ($record = mysqli_fetch_assoc($runQuery)) {
				$results[] = $record;
			}
			// Creating the response object
			$response = (object)null;
			$response->results = $results;
			$response->title = 'Successful';
			$response->description = 'Filter successfully!';
			$response->response_code = "0";
		} else {
			$response = (object)null;
			$response->title = 'Failed';
			$response->description = 'No record found!';
			$response->response_code = '2';
		}
		
	} else {
		// If invalid trans value
		$response = new stdClass();
		$response->title = 'Critical Error!';
		$response->description = 'Invalid transaction.';
		$response->response_code = '1';
	}

	// Send the response as JSON
	header('Content-Type: application/json');
	echo json_encode($response);
